# Duniter Pallet Conventions

## Call

Custom Duniter pallet calls should adhere to the standard Substrate naming convention:

- `action_` for regular calls (e.g., `create_identity`).
- `force_action_` for calls with a privileged origin (e.g., `force_set_distance_status`).

## Error

In the event of a call failure, it should trigger a pallet error with a self-explanatory name, for instance, `IdtyNotFound`.

## Event

Successful calls should deposit a system event to notify external entities of the change. The event name should be self-explanatory and structured in the form of a Rust struct with named fields, ensuring clarity in autogenerated documentation. An example is:

```rust
IdtyRemoved {
    idty_index: T::IdtyIndex,
    reason: IdtyRemovalReason<T::IdtyRemovalOtherReason>,
}
```

## Hook

Hooks are inherently infallible, and no errors should be emitted within them. To monitor progression from inside the hook, events can be employed to inform external entities about changes or no-changes.

## Internal Function

Internal functions should adhere to the following naming convention:

- `do_action_` for regular functions executing the base logic of a call (e.g., `do_remove_identity_`). These functions should directly emit events and trigger errors as needed.
- `force_action_` for privileged functions that bypass any checks. This can be useful for specific benchmarking functions.
- `check_` for functions performing checks and triggering errors in case of failure.
