// Copyright 2021-2022 Axiom-Team
//
// This file is part of Duniter-v2S.
//
// Duniter-v2S is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, version 3 of the License.
//
// Duniter-v2S is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with Duniter-v2S. If not, see <https://www.gnu.org/licenses/>.

//! Autogenerated weights for `pallet_distance`
//!
//! THIS FILE WAS AUTO-GENERATED USING THE SUBSTRATE BENCHMARK CLI VERSION 32.0.0
//! DATE: 2024-09-09, STEPS: `50`, REPEAT: `20`, LOW RANGE: `[]`, HIGH RANGE: `[]`
//! WORST CASE MAP SIZE: `1000000`
//! HOSTNAME: `bgallois-ms7d43`, CPU: `12th Gen Intel(R) Core(TM) i3-12100F`
//! WASM-EXECUTION: `Compiled`, CHAIN: `Some("dev")`, DB CACHE: 1024

// Executed Command:
// target/release/duniter
// benchmark
// pallet
// --chain=dev
// --steps=50
// --repeat=20
// --pallet=*
// --extrinsic=*
// --wasm-execution=compiled
// --heap-pages=4096
// --header=./file_header.txt
// --output=./runtime/gdev/src/weights/

#![cfg_attr(rustfmt, rustfmt_skip)]
#![allow(unused_parens)]
#![allow(unused_imports)]
#![allow(missing_docs)]

use frame_support::{traits::Get, weights::Weight};
use core::marker::PhantomData;

/// Weight functions for `pallet_distance`.
pub struct WeightInfo<T>(PhantomData<T>);
impl<T: frame_system::Config> pallet_distance::WeightInfo for WeightInfo<T> {
	/// Storage: `Identity::IdentityIndexOf` (r:1 w:0)
	/// Proof: `Identity::IdentityIndexOf` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Identity::Identities` (r:1 w:0)
	/// Proof: `Identity::Identities` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::PendingEvaluationRequest` (r:1 w:1)
	/// Proof: `Distance::PendingEvaluationRequest` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Membership::Membership` (r:1 w:0)
	/// Proof: `Membership::Membership` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Parameters::ParametersStorage` (r:1 w:0)
	/// Proof: `Parameters::ParametersStorage` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Certification::StorageIdtyCertMeta` (r:1 w:0)
	/// Proof: `Certification::StorageIdtyCertMeta` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::CurrentPoolIndex` (r:1 w:0)
	/// Proof: `Distance::CurrentPoolIndex` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::EvaluationPool2` (r:1 w:1)
	/// Proof: `Distance::EvaluationPool2` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `System::Account` (r:1 w:1)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(93), added: 2568, mode: `MaxEncodedLen`)
	/// Storage: `Balances::Holds` (r:1 w:1)
	/// Proof: `Balances::Holds` (`max_values`: None, `max_size`: Some(69), added: 2544, mode: `MaxEncodedLen`)
	fn request_distance_evaluation() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `1251`
		//  Estimated: `4716`
		// Minimum execution time: 57_036_000 picoseconds.
		Weight::from_parts(58_881_000, 0)
			.saturating_add(Weight::from_parts(0, 4716))
			.saturating_add(T::DbWeight::get().reads(10))
			.saturating_add(T::DbWeight::get().writes(4))
	}
	/// Storage: `Identity::IdentityIndexOf` (r:1 w:0)
	/// Proof: `Identity::IdentityIndexOf` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Identity::Identities` (r:2 w:0)
	/// Proof: `Identity::Identities` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::PendingEvaluationRequest` (r:1 w:1)
	/// Proof: `Distance::PendingEvaluationRequest` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Membership::Membership` (r:1 w:0)
	/// Proof: `Membership::Membership` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Parameters::ParametersStorage` (r:1 w:0)
	/// Proof: `Parameters::ParametersStorage` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Certification::StorageIdtyCertMeta` (r:1 w:0)
	/// Proof: `Certification::StorageIdtyCertMeta` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::CurrentPoolIndex` (r:1 w:0)
	/// Proof: `Distance::CurrentPoolIndex` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::EvaluationPool2` (r:1 w:1)
	/// Proof: `Distance::EvaluationPool2` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `System::Account` (r:1 w:1)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(93), added: 2568, mode: `MaxEncodedLen`)
	/// Storage: `Balances::Holds` (r:1 w:1)
	/// Proof: `Balances::Holds` (`max_values`: None, `max_size`: Some(69), added: 2544, mode: `MaxEncodedLen`)
	fn request_distance_evaluation_for() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `1280`
		//  Estimated: `7220`
		// Minimum execution time: 60_023_000 picoseconds.
		Weight::from_parts(62_179_000, 0)
			.saturating_add(Weight::from_parts(0, 7220))
			.saturating_add(T::DbWeight::get().reads(11))
			.saturating_add(T::DbWeight::get().writes(4))
	}
	/// Storage: `Distance::DidUpdate` (r:1 w:1)
	/// Proof: `Distance::DidUpdate` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Authorship::Author` (r:1 w:1)
	/// Proof: `Authorship::Author` (`max_values`: Some(1), `max_size`: Some(32), added: 527, mode: `MaxEncodedLen`)
	/// Storage: `System::Digest` (r:1 w:0)
	/// Proof: `System::Digest` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Session::Validators` (r:1 w:0)
	/// Proof: `Session::Validators` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::CurrentPoolIndex` (r:1 w:0)
	/// Proof: `Distance::CurrentPoolIndex` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::EvaluationPool0` (r:1 w:1)
	/// Proof: `Distance::EvaluationPool0` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// The range of component `i` is `[1, 1300]`.
	fn update_evaluation(i: u32, ) -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `402 + i * (10 ±0)`
		//  Estimated: `1887 + i * (10 ±0)`
		// Minimum execution time: 11_979_000 picoseconds.
		Weight::from_parts(12_680_351, 0)
			.saturating_add(Weight::from_parts(0, 1887))
			// Standard Error: 566
			.saturating_add(Weight::from_parts(110_046, 0).saturating_mul(i.into()))
			.saturating_add(T::DbWeight::get().reads(6))
			.saturating_add(T::DbWeight::get().writes(3))
			.saturating_add(Weight::from_parts(0, 10).saturating_mul(i.into()))
	}
	/// Storage: `Distance::CurrentPoolIndex` (r:1 w:0)
	/// Proof: `Distance::CurrentPoolIndex` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::EvaluationPool0` (r:1 w:1)
	/// Proof: `Distance::EvaluationPool0` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// The range of component `i` is `[1, 1300]`.
	fn force_update_evaluation(i: u32, ) -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `139 + i * (10 ±0)`
		//  Estimated: `1624 + i * (10 ±0)`
		// Minimum execution time: 5_096_000 picoseconds.
		Weight::from_parts(7_865_951, 0)
			.saturating_add(Weight::from_parts(0, 1624))
			// Standard Error: 260
			.saturating_add(Weight::from_parts(103_755, 0).saturating_mul(i.into()))
			.saturating_add(T::DbWeight::get().reads(2))
			.saturating_add(T::DbWeight::get().writes(1))
			.saturating_add(Weight::from_parts(0, 10).saturating_mul(i.into()))
	}
	/// Storage: `Identity::Identities` (r:1 w:0)
	/// Proof: `Identity::Identities` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Membership::Membership` (r:1 w:1)
	/// Proof: `Membership::Membership` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Membership::MembershipsExpireOn` (r:2 w:2)
	/// Proof: `Membership::MembershipsExpireOn` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Parameters::ParametersStorage` (r:1 w:0)
	/// Proof: `Parameters::ParametersStorage` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	fn force_valid_distance_status() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `683`
		//  Estimated: `6623`
		// Minimum execution time: 24_382_000 picoseconds.
		Weight::from_parts(25_266_000, 0)
			.saturating_add(Weight::from_parts(0, 6623))
			.saturating_add(T::DbWeight::get().reads(5))
			.saturating_add(T::DbWeight::get().writes(3))
	}
	fn on_initialize_overhead() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `0`
		// Minimum execution time: 83_000 picoseconds.
		Weight::from_parts(109_000, 0)
			.saturating_add(Weight::from_parts(0, 0))
	}
	/// Storage: `System::ParentHash` (r:1 w:0)
	/// Proof: `System::ParentHash` (`max_values`: Some(1), `max_size`: Some(32), added: 527, mode: `MaxEncodedLen`)
	/// Storage: `Distance::EvaluationPool2` (r:1 w:1)
	/// Proof: `Distance::EvaluationPool2` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::PendingEvaluationRequest` (r:1 w:1)
	/// Proof: `Distance::PendingEvaluationRequest` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `System::Account` (r:1 w:1)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(93), added: 2568, mode: `MaxEncodedLen`)
	/// Storage: `Balances::Holds` (r:1 w:1)
	/// Proof: `Balances::Holds` (`max_values`: None, `max_size`: Some(69), added: 2544, mode: `MaxEncodedLen`)
	/// Storage: `Identity::Identities` (r:1 w:0)
	/// Proof: `Identity::Identities` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Membership::Membership` (r:1 w:1)
	/// Proof: `Membership::Membership` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Membership::MembershipsExpireOn` (r:2 w:2)
	/// Proof: `Membership::MembershipsExpireOn` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Parameters::ParametersStorage` (r:1 w:0)
	/// Proof: `Parameters::ParametersStorage` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::EvaluationBlock` (r:0 w:1)
	/// Proof: `Distance::EvaluationBlock` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	fn do_evaluation_success() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `1095`
		//  Estimated: `7035`
		// Minimum execution time: 53_732_000 picoseconds.
		Weight::from_parts(57_160_000, 0)
			.saturating_add(Weight::from_parts(0, 7035))
			.saturating_add(T::DbWeight::get().reads(10))
			.saturating_add(T::DbWeight::get().writes(8))
	}
	/// Storage: `System::ParentHash` (r:1 w:0)
	/// Proof: `System::ParentHash` (`max_values`: Some(1), `max_size`: Some(32), added: 527, mode: `MaxEncodedLen`)
	/// Storage: `Distance::EvaluationPool2` (r:1 w:1)
	/// Proof: `Distance::EvaluationPool2` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::PendingEvaluationRequest` (r:1 w:1)
	/// Proof: `Distance::PendingEvaluationRequest` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Balances::Holds` (r:1 w:1)
	/// Proof: `Balances::Holds` (`max_values`: None, `max_size`: Some(69), added: 2544, mode: `MaxEncodedLen`)
	/// Storage: `System::Account` (r:1 w:1)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(93), added: 2568, mode: `MaxEncodedLen`)
	/// Storage: `Distance::EvaluationBlock` (r:0 w:1)
	/// Proof: `Distance::EvaluationBlock` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	fn do_evaluation_failure() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `412`
		//  Estimated: `3877`
		// Minimum execution time: 24_688_000 picoseconds.
		Weight::from_parts(25_629_000, 0)
			.saturating_add(Weight::from_parts(0, 3877))
			.saturating_add(T::DbWeight::get().reads(5))
			.saturating_add(T::DbWeight::get().writes(5))
	}
	/// Storage: `System::ParentHash` (r:1 w:0)
	/// Proof: `System::ParentHash` (`max_values`: Some(1), `max_size`: Some(32), added: 527, mode: `MaxEncodedLen`)
	/// Storage: `Distance::EvaluationPool2` (r:1 w:0)
	/// Proof: `Distance::EvaluationPool2` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::EvaluationBlock` (r:0 w:1)
	/// Proof: `Distance::EvaluationBlock` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	fn do_evaluation_overhead() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `109`
		//  Estimated: `1594`
		// Minimum execution time: 2_362_000 picoseconds.
		Weight::from_parts(2_657_000, 0)
			.saturating_add(Weight::from_parts(0, 1594))
			.saturating_add(T::DbWeight::get().reads(2))
			.saturating_add(T::DbWeight::get().writes(1))
	}
	/// Storage: `Distance::DidUpdate` (r:1 w:1)
	/// Proof: `Distance::DidUpdate` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	fn on_finalize() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `133`
		//  Estimated: `1618`
		// Minimum execution time: 2_438_000 picoseconds.
		Weight::from_parts(2_544_000, 0)
			.saturating_add(Weight::from_parts(0, 1618))
			.saturating_add(T::DbWeight::get().reads(1))
			.saturating_add(T::DbWeight::get().writes(1))
	}
}
