// Copyright 2021-2022 Axiom-Team
//
// This file is part of Duniter-v2S.
//
// Duniter-v2S is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, version 3 of the License.
//
// Duniter-v2S is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with Duniter-v2S. If not, see <https://www.gnu.org/licenses/>.

//! Autogenerated weights for `pallet_quota`
//!
//! THIS FILE WAS AUTO-GENERATED USING THE SUBSTRATE BENCHMARK CLI VERSION 32.0.0
//! DATE: 2024-09-09, STEPS: `50`, REPEAT: `20`, LOW RANGE: `[]`, HIGH RANGE: `[]`
//! WORST CASE MAP SIZE: `1000000`
//! HOSTNAME: `bgallois-ms7d43`, CPU: `12th Gen Intel(R) Core(TM) i3-12100F`
//! WASM-EXECUTION: `Compiled`, CHAIN: `Some("dev")`, DB CACHE: 1024

// Executed Command:
// target/release/duniter
// benchmark
// pallet
// --chain=dev
// --steps=50
// --repeat=20
// --pallet=*
// --extrinsic=*
// --wasm-execution=compiled
// --heap-pages=4096
// --header=./file_header.txt
// --output=./runtime/gdev/src/weights/

#![cfg_attr(rustfmt, rustfmt_skip)]
#![allow(unused_parens)]
#![allow(unused_imports)]
#![allow(missing_docs)]

use frame_support::{traits::Get, weights::Weight};
use core::marker::PhantomData;

/// Weight functions for `pallet_quota`.
pub struct WeightInfo<T>(PhantomData<T>);
impl<T: frame_system::Config> pallet_quota::WeightInfo for WeightInfo<T> {
	/// Storage: `Quota::RefundQueue` (r:1 w:1)
	/// Proof: `Quota::RefundQueue` (`max_values`: Some(1), `max_size`: Some(11266), added: 11761, mode: `MaxEncodedLen`)
	fn queue_refund() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `11288`
		//  Estimated: `12751`
		// Minimum execution time: 7_179_000 picoseconds.
		Weight::from_parts(7_406_000, 0)
			.saturating_add(Weight::from_parts(0, 12751))
			.saturating_add(T::DbWeight::get().reads(1))
			.saturating_add(T::DbWeight::get().writes(1))
	}
	/// Storage: `Quota::IdtyQuota` (r:1 w:1)
	/// Proof: `Quota::IdtyQuota` (`max_values`: None, `max_size`: Some(24), added: 2499, mode: `MaxEncodedLen`)
	fn spend_quota() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `172`
		//  Estimated: `3489`
		// Minimum execution time: 4_517_000 picoseconds.
		Weight::from_parts(4_765_000, 0)
			.saturating_add(Weight::from_parts(0, 3489))
			.saturating_add(T::DbWeight::get().reads(1))
			.saturating_add(T::DbWeight::get().writes(1))
	}
	/// Storage: `Quota::IdtyQuota` (r:1 w:1)
	/// Proof: `Quota::IdtyQuota` (`max_values`: None, `max_size`: Some(24), added: 2499, mode: `MaxEncodedLen`)
	/// Storage: `System::Account` (r:2 w:1)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(93), added: 2568, mode: `MaxEncodedLen`)
	fn try_refund() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `235`
		//  Estimated: `6126`
		// Minimum execution time: 22_133_000 picoseconds.
		Weight::from_parts(22_941_000, 0)
			.saturating_add(Weight::from_parts(0, 6126))
			.saturating_add(T::DbWeight::get().reads(3))
			.saturating_add(T::DbWeight::get().writes(2))
	}
	/// Storage: `Quota::IdtyQuota` (r:1 w:1)
	/// Proof: `Quota::IdtyQuota` (`max_values`: None, `max_size`: Some(24), added: 2499, mode: `MaxEncodedLen`)
	/// Storage: `System::Account` (r:2 w:1)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(93), added: 2568, mode: `MaxEncodedLen`)
	fn do_refund() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `235`
		//  Estimated: `6126`
		// Minimum execution time: 22_539_000 picoseconds.
		Weight::from_parts(23_146_000, 0)
			.saturating_add(Weight::from_parts(0, 6126))
			.saturating_add(T::DbWeight::get().reads(3))
			.saturating_add(T::DbWeight::get().writes(2))
	}
	/// Storage: `Quota::RefundQueue` (r:1 w:1)
	/// Proof: `Quota::RefundQueue` (`max_values`: Some(1), `max_size`: Some(11266), added: 11761, mode: `MaxEncodedLen`)
	fn on_process_refund_queue() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `43`
		//  Estimated: `12751`
		// Minimum execution time: 1_856_000 picoseconds.
		Weight::from_parts(1_971_000, 0)
			.saturating_add(Weight::from_parts(0, 12751))
			.saturating_add(T::DbWeight::get().reads(1))
			.saturating_add(T::DbWeight::get().writes(1))
	}
	/// Storage: `Quota::RefundQueue` (r:1 w:1)
	/// Proof: `Quota::RefundQueue` (`max_values`: Some(1), `max_size`: Some(11266), added: 11761, mode: `MaxEncodedLen`)
	/// Storage: `Quota::IdtyQuota` (r:1 w:1)
	/// Proof: `Quota::IdtyQuota` (`max_values`: None, `max_size`: Some(24), added: 2499, mode: `MaxEncodedLen`)
	/// Storage: `System::Account` (r:2 w:1)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(93), added: 2568, mode: `MaxEncodedLen`)
	/// The range of component `i` is `[1, 256]`.
	fn on_process_refund_queue_elements(i: u32, ) -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `260 + i * (44 ±0)`
		//  Estimated: `12751`
		// Minimum execution time: 24_314_000 picoseconds.
		Weight::from_parts(36_292_778, 0)
			.saturating_add(Weight::from_parts(0, 12751))
			// Standard Error: 3_497
			.saturating_add(Weight::from_parts(1_246_478, 0).saturating_mul(i.into()))
			.saturating_add(T::DbWeight::get().reads(4))
			.saturating_add(T::DbWeight::get().writes(3))
	}
}
