// Copyright 2021-2022 Axiom-Team
//
// This file is part of Duniter-v2S.
//
// Duniter-v2S is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, version 3 of the License.
//
// Duniter-v2S is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with Duniter-v2S. If not, see <https://www.gnu.org/licenses/>.

//! Autogenerated weights for `pallet_distance`
//!
//! THIS FILE WAS AUTO-GENERATED USING THE SUBSTRATE BENCHMARK CLI VERSION 32.0.0
//! DATE: 2025-01-22, STEPS: `50`, REPEAT: `20`, LOW RANGE: `[]`, HIGH RANGE: `[]`
//! WORST CASE MAP SIZE: `1000000`
//! HOSTNAME: `bgallois-ms7d43`, CPU: `12th Gen Intel(R) Core(TM) i3-12100F`
//! WASM-EXECUTION: `Compiled`, CHAIN: `None`, DB CACHE: 1024

// Executed Command:
// target/release/duniter
// benchmark
// pallet
// --genesis-builder=spec-genesis
// --steps=50
// --repeat=20
// --pallet=*
// --extrinsic=*
// --wasm-execution=compiled
// --heap-pages=4096
// --header=./file_header.txt
// --output=./runtime/g1/src/weights/

#![cfg_attr(rustfmt, rustfmt_skip)]
#![allow(unused_parens)]
#![allow(unused_imports)]
#![allow(missing_docs)]

use frame_support::{traits::Get, weights::Weight};
use core::marker::PhantomData;

/// Weight functions for `pallet_distance`.
pub struct WeightInfo<T>(PhantomData<T>);
impl<T: frame_system::Config> pallet_distance::WeightInfo for WeightInfo<T> {
	/// Storage: `Identity::IdentityIndexOf` (r:1 w:0)
	/// Proof: `Identity::IdentityIndexOf` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Identity::Identities` (r:1 w:0)
	/// Proof: `Identity::Identities` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::PendingEvaluationRequest` (r:1 w:1)
	/// Proof: `Distance::PendingEvaluationRequest` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Membership::Membership` (r:1 w:0)
	/// Proof: `Membership::Membership` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Certification::StorageIdtyCertMeta` (r:1 w:0)
	/// Proof: `Certification::StorageIdtyCertMeta` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::CurrentPeriodIndex` (r:1 w:0)
	/// Proof: `Distance::CurrentPeriodIndex` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::EvaluationPool2` (r:1 w:1)
	/// Proof: `Distance::EvaluationPool2` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `System::Account` (r:1 w:1)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(93), added: 2568, mode: `MaxEncodedLen`)
	/// Storage: `Balances::Holds` (r:1 w:1)
	/// Proof: `Balances::Holds` (`max_values`: None, `max_size`: Some(89), added: 2564, mode: `MaxEncodedLen`)
	fn request_distance_evaluation() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `1134`
		//  Estimated: `4599`
		// Minimum execution time: 63_647_000 picoseconds.
		Weight::from_parts(66_503_000, 0)
			.saturating_add(Weight::from_parts(0, 4599))
			.saturating_add(T::DbWeight::get().reads(9))
			.saturating_add(T::DbWeight::get().writes(4))
	}
	/// Storage: `Identity::IdentityIndexOf` (r:1 w:0)
	/// Proof: `Identity::IdentityIndexOf` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Identity::Identities` (r:2 w:0)
	/// Proof: `Identity::Identities` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::PendingEvaluationRequest` (r:1 w:1)
	/// Proof: `Distance::PendingEvaluationRequest` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Membership::Membership` (r:1 w:0)
	/// Proof: `Membership::Membership` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Certification::StorageIdtyCertMeta` (r:1 w:0)
	/// Proof: `Certification::StorageIdtyCertMeta` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::CurrentPeriodIndex` (r:1 w:0)
	/// Proof: `Distance::CurrentPeriodIndex` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::EvaluationPool2` (r:1 w:1)
	/// Proof: `Distance::EvaluationPool2` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `System::Account` (r:1 w:1)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(93), added: 2568, mode: `MaxEncodedLen`)
	/// Storage: `Balances::Holds` (r:1 w:1)
	/// Proof: `Balances::Holds` (`max_values`: None, `max_size`: Some(89), added: 2564, mode: `MaxEncodedLen`)
	fn request_distance_evaluation_for() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `1163`
		//  Estimated: `7103`
		// Minimum execution time: 66_742_000 picoseconds.
		Weight::from_parts(70_145_000, 0)
			.saturating_add(Weight::from_parts(0, 7103))
			.saturating_add(T::DbWeight::get().reads(10))
			.saturating_add(T::DbWeight::get().writes(4))
	}
	/// Storage: `Distance::DidUpdate` (r:1 w:1)
	/// Proof: `Distance::DidUpdate` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Session::Validators` (r:1 w:0)
	/// Proof: `Session::Validators` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::CurrentPeriodIndex` (r:1 w:0)
	/// Proof: `Distance::CurrentPeriodIndex` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::EvaluationPool0` (r:1 w:1)
	/// Proof: `Distance::EvaluationPool0` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// The range of component `i` is `[1, 1300]`.
	fn update_evaluation(i: u32, ) -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `303 + i * (10 ±0)`
		//  Estimated: `1788 + i * (10 ±0)`
		// Minimum execution time: 12_663_000 picoseconds.
		Weight::from_parts(15_006_914, 0)
			.saturating_add(Weight::from_parts(0, 1788))
			// Standard Error: 108
			.saturating_add(Weight::from_parts(113_787, 0).saturating_mul(i.into()))
			.saturating_add(T::DbWeight::get().reads(4))
			.saturating_add(T::DbWeight::get().writes(2))
			.saturating_add(Weight::from_parts(0, 10).saturating_mul(i.into()))
	}
	/// Storage: `Distance::CurrentPeriodIndex` (r:1 w:0)
	/// Proof: `Distance::CurrentPeriodIndex` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::EvaluationPool0` (r:1 w:1)
	/// Proof: `Distance::EvaluationPool0` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// The range of component `i` is `[1, 1300]`.
	fn force_update_evaluation(i: u32, ) -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `162 + i * (10 ±0)`
		//  Estimated: `1647 + i * (10 ±0)`
		// Minimum execution time: 7_669_000 picoseconds.
		Weight::from_parts(9_638_272, 0)
			.saturating_add(Weight::from_parts(0, 1647))
			// Standard Error: 91
			.saturating_add(Weight::from_parts(102_085, 0).saturating_mul(i.into()))
			.saturating_add(T::DbWeight::get().reads(2))
			.saturating_add(T::DbWeight::get().writes(1))
			.saturating_add(Weight::from_parts(0, 10).saturating_mul(i.into()))
	}
	/// Storage: `Identity::Identities` (r:1 w:0)
	/// Proof: `Identity::Identities` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Membership::Membership` (r:1 w:1)
	/// Proof: `Membership::Membership` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Membership::MembershipsExpireOn` (r:2 w:2)
	/// Proof: `Membership::MembershipsExpireOn` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn force_valid_distance_status() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `539`
		//  Estimated: `6479`
		// Minimum execution time: 26_972_000 picoseconds.
		Weight::from_parts(28_173_000, 0)
			.saturating_add(Weight::from_parts(0, 6479))
			.saturating_add(T::DbWeight::get().reads(4))
			.saturating_add(T::DbWeight::get().writes(3))
	}
	fn on_initialize_overhead() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `0`
		// Minimum execution time: 93_000 picoseconds.
		Weight::from_parts(123_000, 0)
			.saturating_add(Weight::from_parts(0, 0))
	}
	/// Storage: `System::ParentHash` (r:1 w:0)
	/// Proof: `System::ParentHash` (`max_values`: Some(1), `max_size`: Some(32), added: 527, mode: `MaxEncodedLen`)
	/// Storage: `Distance::EvaluationPool2` (r:1 w:1)
	/// Proof: `Distance::EvaluationPool2` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::PendingEvaluationRequest` (r:1 w:1)
	/// Proof: `Distance::PendingEvaluationRequest` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `System::Account` (r:1 w:1)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(93), added: 2568, mode: `MaxEncodedLen`)
	/// Storage: `Balances::Holds` (r:1 w:1)
	/// Proof: `Balances::Holds` (`max_values`: None, `max_size`: Some(89), added: 2564, mode: `MaxEncodedLen`)
	/// Storage: `Identity::Identities` (r:1 w:0)
	/// Proof: `Identity::Identities` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Membership::Membership` (r:1 w:1)
	/// Proof: `Membership::Membership` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Membership::MembershipsExpireOn` (r:2 w:2)
	/// Proof: `Membership::MembershipsExpireOn` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::EvaluationBlock` (r:0 w:1)
	/// Proof: `Distance::EvaluationBlock` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	fn do_evaluation_success() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `951`
		//  Estimated: `6891`
		// Minimum execution time: 60_114_000 picoseconds.
		Weight::from_parts(61_534_000, 0)
			.saturating_add(Weight::from_parts(0, 6891))
			.saturating_add(T::DbWeight::get().reads(9))
			.saturating_add(T::DbWeight::get().writes(8))
	}
	/// Storage: `System::ParentHash` (r:1 w:0)
	/// Proof: `System::ParentHash` (`max_values`: Some(1), `max_size`: Some(32), added: 527, mode: `MaxEncodedLen`)
	/// Storage: `Distance::EvaluationPool2` (r:1 w:1)
	/// Proof: `Distance::EvaluationPool2` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::PendingEvaluationRequest` (r:1 w:1)
	/// Proof: `Distance::PendingEvaluationRequest` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Balances::Holds` (r:1 w:1)
	/// Proof: `Balances::Holds` (`max_values`: None, `max_size`: Some(89), added: 2564, mode: `MaxEncodedLen`)
	/// Storage: `System::Account` (r:2 w:2)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(93), added: 2568, mode: `MaxEncodedLen`)
	/// Storage: `Distance::EvaluationBlock` (r:0 w:1)
	/// Proof: `Distance::EvaluationBlock` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	fn do_evaluation_failure() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `475`
		//  Estimated: `6126`
		// Minimum execution time: 42_364_000 picoseconds.
		Weight::from_parts(43_874_000, 0)
			.saturating_add(Weight::from_parts(0, 6126))
			.saturating_add(T::DbWeight::get().reads(6))
			.saturating_add(T::DbWeight::get().writes(6))
	}
	/// Storage: `System::ParentHash` (r:1 w:0)
	/// Proof: `System::ParentHash` (`max_values`: Some(1), `max_size`: Some(32), added: 527, mode: `MaxEncodedLen`)
	/// Storage: `Distance::EvaluationPool2` (r:1 w:0)
	/// Proof: `Distance::EvaluationPool2` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Distance::EvaluationBlock` (r:0 w:1)
	/// Proof: `Distance::EvaluationBlock` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	fn do_evaluation_overhead() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `136`
		//  Estimated: `1621`
		// Minimum execution time: 4_453_000 picoseconds.
		Weight::from_parts(4_799_000, 0)
			.saturating_add(Weight::from_parts(0, 1621))
			.saturating_add(T::DbWeight::get().reads(2))
			.saturating_add(T::DbWeight::get().writes(1))
	}
	/// Storage: `Distance::DidUpdate` (r:1 w:1)
	/// Proof: `Distance::DidUpdate` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	fn on_finalize() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `157`
		//  Estimated: `1642`
		// Minimum execution time: 4_346_000 picoseconds.
		Weight::from_parts(4_531_000, 0)
			.saturating_add(Weight::from_parts(0, 1642))
			.saturating_add(T::DbWeight::get().reads(1))
			.saturating_add(T::DbWeight::get().writes(1))
	}
}
