// Copyright 2021-2022 Axiom-Team
//
// This file is part of Duniter-v2S.
//
// Duniter-v2S is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, version 3 of the License.
//
// Duniter-v2S is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with Duniter-v2S. If not, see <https://www.gnu.org/licenses/>.

//! Autogenerated weights for `pallet_treasury`
//!
//! THIS FILE WAS AUTO-GENERATED USING THE SUBSTRATE BENCHMARK CLI VERSION 32.0.0
//! DATE: 2025-01-22, STEPS: `50`, REPEAT: `20`, LOW RANGE: `[]`, HIGH RANGE: `[]`
//! WORST CASE MAP SIZE: `1000000`
//! HOSTNAME: `bgallois-ms7d43`, CPU: `12th Gen Intel(R) Core(TM) i3-12100F`
//! WASM-EXECUTION: `Compiled`, CHAIN: `None`, DB CACHE: 1024

// Executed Command:
// target/release/duniter
// benchmark
// pallet
// --genesis-builder=spec-genesis
// --steps=50
// --repeat=20
// --pallet=*
// --extrinsic=*
// --wasm-execution=compiled
// --heap-pages=4096
// --header=./file_header.txt
// --output=./runtime/gtest/src/weights/

#![cfg_attr(rustfmt, rustfmt_skip)]
#![allow(unused_parens)]
#![allow(unused_imports)]
#![allow(missing_docs)]

use frame_support::{traits::Get, weights::Weight};
use core::marker::PhantomData;

/// Weight functions for `pallet_treasury`.
pub struct WeightInfo<T>(PhantomData<T>);
impl<T: frame_system::Config> pallet_treasury::WeightInfo for WeightInfo<T> {
	fn spend_local() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `0`
		// Minimum execution time: 0_000 picoseconds.
		Weight::from_parts(0, 0)
			.saturating_add(Weight::from_parts(0, 0))
	}
	/// Storage: `Treasury::Approvals` (r:1 w:0)
	/// Proof: `Treasury::Approvals` (`max_values`: Some(1), `max_size`: Some(402), added: 897, mode: `MaxEncodedLen`)
	fn remove_approval() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `6`
		//  Estimated: `1887`
		// Minimum execution time: 3_447_000 picoseconds.
		Weight::from_parts(3_621_000, 0)
			.saturating_add(Weight::from_parts(0, 1887))
			.saturating_add(T::DbWeight::get().reads(1))
	}
	/// Storage: `System::Account` (r:1 w:0)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(93), added: 2568, mode: `MaxEncodedLen`)
	/// Storage: `Treasury::Deactivated` (r:1 w:1)
	/// Proof: `Treasury::Deactivated` (`max_values`: Some(1), `max_size`: Some(8), added: 503, mode: `MaxEncodedLen`)
	/// Storage: `Treasury::LastSpendPeriod` (r:1 w:1)
	/// Proof: `Treasury::LastSpendPeriod` (`max_values`: Some(1), `max_size`: Some(4), added: 499, mode: `MaxEncodedLen`)
	/// The range of component `p` is `[0, 99]`.
	fn on_initialize_proposals(p: u32, ) -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `82 + p * (1 ±0)`
		//  Estimated: `3558`
		// Minimum execution time: 10_682_000 picoseconds.
		Weight::from_parts(12_020_888, 0)
			.saturating_add(Weight::from_parts(0, 3558))
			// Standard Error: 417
			.saturating_add(Weight::from_parts(22_993, 0).saturating_mul(p.into()))
			.saturating_add(T::DbWeight::get().reads(3))
			.saturating_add(T::DbWeight::get().writes(2))
	}
	fn spend() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `0`
		// Minimum execution time: 0_000 picoseconds.
		Weight::from_parts(0, 0)
			.saturating_add(Weight::from_parts(0, 0))
	}
	/// Storage: `Treasury::Spends` (r:1 w:0)
	/// Proof: `Treasury::Spends` (`max_values`: None, `max_size`: Some(61), added: 2536, mode: `MaxEncodedLen`)
	fn payout() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `6`
		//  Estimated: `3526`
		// Minimum execution time: 4_535_000 picoseconds.
		Weight::from_parts(4_862_000, 0)
			.saturating_add(Weight::from_parts(0, 3526))
			.saturating_add(T::DbWeight::get().reads(1))
	}
	/// Storage: `Treasury::Spends` (r:1 w:0)
	/// Proof: `Treasury::Spends` (`max_values`: None, `max_size`: Some(61), added: 2536, mode: `MaxEncodedLen`)
	fn check_status() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `6`
		//  Estimated: `3526`
		// Minimum execution time: 4_604_000 picoseconds.
		Weight::from_parts(4_766_000, 0)
			.saturating_add(Weight::from_parts(0, 3526))
			.saturating_add(T::DbWeight::get().reads(1))
	}
	/// Storage: `Treasury::Spends` (r:1 w:0)
	/// Proof: `Treasury::Spends` (`max_values`: None, `max_size`: Some(61), added: 2536, mode: `MaxEncodedLen`)
	fn void_spend() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `6`
		//  Estimated: `3526`
		// Minimum execution time: 4_143_000 picoseconds.
		Weight::from_parts(4_415_000, 0)
			.saturating_add(Weight::from_parts(0, 3526))
			.saturating_add(T::DbWeight::get().reads(1))
	}
}
